/*
 *  SphereCoord.cpp
 *  emptyExample
 *
 *  Created by Josh Nimoy on 4/13/10.
 *  Copyright 2010 Josh Nimoy. All rights reserved.
 *
 */

#include "SphereCoord.h"
#include "JPoint.h"


SphereCoord::SphereCoord(float rr,float tt,float pp){
	r = rr;
	theta = tt;
	phi = pp;
}

SphereCoord::SphereCoord(){
	r = 0;
	theta = 0;
	phi = 0;
}


JPoint SphereCoord::getCartesian(){
	return JPoint(
				  r * sin(theta) * cos(phi),
				  r * sin(theta) * sin(phi),
				  r * cos(theta)
				  );
}

SphereCoord::operator JPoint(){
	return getCartesian();
}

